\name{alt_70_cellulitis}
\alias{alt_70_cellulitis}
\title{
ALT-70 Score for Cellulitis
}
\description{
Calculates the ALT-70 score to predict the likelihood of lower extremity cellulitis. This score helps differentiate true cellulitis from cellulitis mimics (pseudocellulitis) such as stasis dermatitis, which are often misdiagnosed and mistreated with antibiotics.
}
\usage{
alt_70_cellulitis(asymmetry, leukocytosis, tachycardia, age_ge_70)
}
\arguments{
  \item{asymmetry}{
Numeric (0 or 1). Is the leg involvement unilateral? (1 = Yes/Asymmetric, 0 = No/Bilateral). Note: Bilateral involvement strongly suggests a mimic. (+3 points).
}
  \item{leukocytosis}{
Numeric (0 or 1). WBC >= 10,000/uL (or >= 10.0 k/uL). (1 = Yes, +1 point).
}
  \item{tachycardia}{
Numeric (0 or 1). Heart rate >= 90 bpm. (1 = Yes, +1 point).
}
  \item{age_ge_70}{
Numeric (0 or 1). Age >= 70 years. (1 = Yes, +2 points).
}
}
\value{
A list containing:
\item{Total_Score}{The calculated ALT-70 score (Range 0-7).}
\item{Likelihood}{Estimated probability of true cellulitis.}
\item{Recommendation}{Clinical guidance based on the score (e.g., Consider mimics vs. Treat).}
}
\references{
Raff AB, Weng QY, Cohen JM, et al. A predictive model for diagnosis of lower extremity cellulitis: A cross-sectional study. J Am Acad Dermatol. 2017;76(4):618-625.e2. doi:10.1016/j.jaad.2016.12.044
}
\examples{

# Example 1: High Likelihood
# Unilateral leg redness (+3), HR 95 (+1), Age 75 (+2), Normal WBC (0)
# Score = 6
alt_70_cellulitis(1, 0, 1, 1)

# Example 2: Low Likelihood (Likely Stasis Dermatitis)
# Bilateral redness (0), Age 65 (0), No systemic signs
# Score = 0
alt_70_cellulitis(0, 0, 0, 0)
}
