\name{adapt_cardiac_risk}
\alias{adapt_cardiac_risk}
\title{
ADAPT Protocol for Cardiac Event Risk
}
\description{
Implements the 2-Hour Accelerated Diagnostic Protocol to Assess Patients with Chest Pain Symptoms (ADAPT). This protocol identifies low-risk patients who can be safely discharged from the Emergency Department within 2 hours.

To be classified as "Low Risk" (safe for discharge), a patient must meet ALL of the following criteria:
1. TIMI Score = 0.
2. No new ischemic changes on ECG.
3. Negative Troponin at 0 hours.
4. Negative Troponin at 2 hours.
}
\usage{
adapt_cardiac_risk(timi_score, ekg_new_ischemia,
troponin_0h_positive, troponin_2h_positive)
}
\arguments{
  \item{timi_score}{
Numeric. The patient's TIMI Risk Score for UA/NSTEMI (Range 0-7).
}
  \item{ekg_new_ischemia}{
Numeric (0 or 1). Presence of new ischemic changes on ECG. (1 = Yes, 0 = No).
}
  \item{troponin_0h_positive}{
Numeric (0 or 1). Baseline (0-hour) troponin result above the institutional cutoff. (1 = Positive, 0 = Negative).
}
  \item{troponin_2h_positive}{
Numeric (0 or 1). 2-hour troponin result above the institutional cutoff. (1 = Positive, 0 = Negative).
}
}
\value{
A list containing:
\item{Risk_Category}{"Low Risk" or "Not Low Risk".}
\item{MACE_Risk_30_Day}{Estimated risk of Major Adverse Cardiac Events at 30 days.}
\item{Recommendation}{Clinical guidance regarding discharge vs. observation.}
}
\references{
Than M, Cullen L, Aldous S, et al. 2-Hour Accelerated Diagnostic Protocol to Assess Patients With Chest Pain Symptoms Using Contemporary Troponins as the Only Biomarker: The ADAPT Trial. J Am Coll Cardiol. 2012;59(23):2091-2098. doi:10.1016/j.jacc.2012.02.035
}
\examples{

# Example 1: Low Risk (Safe for discharge)
# TIMI 0, No EKG changes, Negative Troponins x2
adapt_cardiac_risk(0, 0, 0, 0)

# Example 2: Not Low Risk
# TIMI 1, No EKG changes, Negative Troponins x2
adapt_cardiac_risk(1, 0, 0, 0)

# Example 3: Not Low Risk
# TIMI 0, No EKG changes, Positive 2h Troponin
adapt_cardiac_risk(0, 0, 0, 1)
}
