% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots-palettesCDISC.R
\name{getPaletteCDISC}
\alias{getPaletteCDISC}
\title{Get standard palette for typical CDISC variables.}
\usage{
getPaletteCDISC(x, var, type, palette = NULL)
}
\arguments{
\item{x}{Character vector of factor with
variable to consider.
The palette is built based on the unique elements
of this vector, or levels if \code{x} is a factor.}

\item{var}{String with type of variable, among:
\itemize{
\item 'NRIND': Normal Reference Range Indicator
}}

\item{type}{String with type of palette:
\itemize{
\item 'shape': shape/symbol palette
\item 'color': color palette
}}

\item{palette}{(optional) Named vector
with extra palette, e.g. to specify elements
for non-standard categories.
This palette is combined with the standard palette.}
}
\value{
Named vector with palette.
}
\description{
The extraction of the palette elements is case-insensitive.
}
\details{
The order of the palette depends on the type of the input
variable (\code{x}):
\itemize{
\item if a factor is specified, the palette is ordered based
on its levels
\item if a character vector is specified,
the elements from the internal standard palette are used first,
the remaining elements are then sorted alphabetically.
}
}
\examples{

## palette for reference range indicator variables

xRIND <- c("LOW", "HIGH", "NORMAL", "NORMAL", "NORMAL", "ABNORMAL")

# get standard palette
getPaletteCDISC(x = xRIND, var = "NRIND", type = "shape")
getPaletteCDISC(x = xRIND, var = "NRIND", type = "color")

# in case extra categories are specified:
xRIND <- c(xRIND, "High Panic")
# the symbols are set to numeric symbols
getPaletteCDISC(xRIND, var = "NRIND", type = "shape")
# use shapePalette to specify symbols for extra categories
getPaletteCDISC(xRIND, var = "NRIND", type = "shape", palette = c("High Panic" = "\u2666"))

# palette is case-insensitive
xRIND <- c("Low", "High", "Normal", "Normal", "Normal")
getPaletteCDISC(xRIND, var = "NRIND", type = "shape")
}
\author{
Laure Cougnaud
}
