% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_ratings.R
\name{cfbd_ratings_srs}
\alias{cfbd_ratings_srs}
\title{\strong{Get SRS historical rating data}}
\usage{
cfbd_ratings_srs(year = NULL, team = NULL, conference = NULL)
}
\arguments{
\item{year}{(\emph{Integer} optional): Year, 4 digit format (\emph{YYYY}). Required if team not provided}

\item{team}{(\emph{String} optional): D-I Team. Required if year not provided}

\item{conference}{(\emph{String} optional): Conference abbreviation - SRS information by conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}
}
\value{
\code{\link[=cfbd_ratings_srs]{cfbd_ratings_srs()}} - A data frame with 6 variables:
\describe{
\item{\code{year}: integer.}{Season of the SRS rating.}
\item{\code{team}: character.}{Team name.}
\item{\code{conference}: character.}{Conference of the team.}
\item{\code{division}: logical.}{Division in the conference for the team.}
\item{\code{rating}: double.}{Simple Rating System (SRS) rating.}
\item{\code{ranking}: integer.}{Simple Rating System ranking within the group returned.}
}
}
\description{
At least one of \strong{year} or \strong{team} must be specified for the function to run
}
\examples{
\donttest{
  try(cfbd_ratings_srs(year = 2019, team = "Texas"))

  try(cfbd_ratings_srs(year = 2018, conference = "SEC"))
}

}
\seealso{
Other CFBD Ratings and Rankings: 
\code{\link{cfbd_rankings}()},
\code{\link{cfbd_ratings_elo}()},
\code{\link{cfbd_ratings_fpi}()},
\code{\link{cfbd_ratings_sp}()},
\code{\link{cfbd_ratings_sp_conference}()}
}
\concept{CFBD Ratings and Rankings}
\keyword{SRS}
