% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cfbd_games.R
\name{cfbd_game_player_stats}
\alias{cfbd_game_player_stats}
\title{\strong{Get player statistics by game}}
\usage{
cfbd_game_player_stats(
  year,
  week = NULL,
  season_type = "regular",
  team = NULL,
  conference = NULL,
  category = NULL,
  game_id = NULL
)
}
\arguments{
\item{year}{(\emph{Integer} required): Year, 4 digit format(\emph{YYYY})}

\item{week}{(\emph{Integer} optional): Week - values from 1-15, 1-14 for seasons pre-playoff (i.e. 2013 or earlier)}

\item{season_type}{(\emph{String} default regular): Select Season Type: regular, postseason, both, allstar, spring_regular, spring_postseason}

\item{team}{(\emph{String} optional): D-I Team}

\item{conference}{(\emph{String} optional): Conference abbreviation - Select a valid FBS conference
Conference abbreviations P5: ACC, B12, B1G, SEC, PAC
Conference abbreviations G5 and FBS Independents: CUSA, MAC, MWC, Ind, SBC, AAC}

\item{category}{(\emph{String} optional): Category filter (e.g defensive)
Offense: passing, receiving, rushing
Defense: defensive, fumbles, interceptions
Special Teams: punting, puntReturns, kicking, kickReturns}

\item{game_id}{(\emph{Integer} optional): Game ID filter for querying a single game
Can be found using the \code{\link[=cfbd_game_info]{cfbd_game_info()}} function}
}
\value{
\code{\link[=cfbd_game_player_stats]{cfbd_game_player_stats()}} - A data frame with 32 variables:\tabular{ll}{
   col_name \tab types \cr
   game_id \tab integer \cr
   team \tab character \cr
   conference \tab character \cr
   home_away \tab character \cr
   team_points \tab integer \cr
   athlete_id \tab integer \cr
   athlete_name \tab character \cr
   defensive_td \tab numeric \cr
   defensive_qb_hur \tab numeric \cr
   defensive_pd \tab numeric \cr
   defensive_tfl \tab numeric \cr
   defensive_sacks \tab numeric \cr
   defensive_solo \tab numeric \cr
   defensive_tot \tab numeric \cr
   fumbles_rec \tab numeric \cr
   fumbles_lost \tab numeric \cr
   fumbles_fum \tab numeric \cr
   punting_long \tab numeric \cr
   punting_in_20 \tab numeric \cr
   punting_tb \tab numeric \cr
   punting_avg \tab numeric \cr
   punting_yds \tab numeric \cr
   punting_no \tab numeric \cr
   kicking_pts \tab numeric \cr
   kicking_long \tab numeric \cr
   kicking_pct \tab numeric \cr
   punt_returns_td \tab numeric \cr
   punt_returns_long \tab numeric \cr
   punt_returns_avg \tab numeric \cr
   punt_returns_yds \tab numeric \cr
   punt_returns_no \tab numeric \cr
   kick_returns_td \tab numeric \cr
   kick_returns_long \tab numeric \cr
   kick_returns_avg \tab numeric \cr
   kick_returns_yds \tab numeric \cr
   kick_returns_no \tab numeric \cr
   interceptions_td \tab numeric \cr
   interceptions_yds \tab numeric \cr
   interceptions_int \tab numeric \cr
   receiving_long \tab numeric \cr
   receiving_td \tab numeric \cr
   receiving_avg \tab numeric \cr
   receiving_yds \tab numeric \cr
   receiving_rec \tab numeric \cr
   rushing_long \tab numeric \cr
   rushing_td \tab numeric \cr
   rushing_avg \tab numeric \cr
   rushing_yds \tab numeric \cr
   rushing_car \tab numeric \cr
   passing_int \tab numeric \cr
   passing_td \tab numeric \cr
   passing_avg \tab numeric \cr
   passing_yds \tab numeric \cr
   passing_completions \tab numeric \cr
   passing_attempts \tab numeric \cr
   passing_qbr \tab numeric \cr
   kicking_xpm \tab numeric \cr
   kicking_xpa \tab numeric \cr
   kicking_fgm \tab numeric \cr
   kicking_fga \tab numeric \cr
}
}
\description{
\strong{Get player statistics by game}
}
\examples{
\donttest{
  try(cfbd_game_player_stats(year = 2020, week = 15, team = "Alabama"))

  try(cfbd_game_player_stats(2013, week = 1, team = "Florida State", category = "passing"))
}
}
\seealso{
Other CFBD Games: 
\code{\link{cfbd_calendar}()},
\code{\link{cfbd_game_box_advanced}()},
\code{\link{cfbd_game_info}()},
\code{\link{cfbd_game_media}()},
\code{\link{cfbd_game_records}()},
\code{\link{cfbd_game_team_stats}()},
\code{\link{cfbd_game_weather}()},
\code{\link{cfbd_live_scoreboard}()}
}
\concept{CFBD Games}
\keyword{Game}
\keyword{Info}
