% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_all_ces_datasets.R
\name{download_all_ces_datasets}
\alias{download_all_ces_datasets}
\title{Download All Canadian Election Study Datasets}
\usage{
download_all_ces_datasets(
  path = NULL,
  years = NULL,
  variants = NULL,
  overwrite = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{A character string indicating the directory where the datasets should
be saved. If NULL (default), the datasets will be saved to the Downloads
directory if available, otherwise to a temporary directory.}

\item{years}{Optional character vector specifying which years to download.
If NULL (default), all available years will be downloaded.}

\item{variants}{Optional character vector specifying which variants to download.
If NULL (default), all available variants will be downloaded.}

\item{overwrite}{Logical indicating whether to overwrite existing files.
Default is FALSE.}

\item{verbose}{Logical indicating whether to display detailed progress messages
during download. Default is TRUE.}
}
\value{
Invisibly returns a character vector with the file paths of the downloaded datasets.
}
\description{
This function downloads all available Canadian Election Study datasets to a specified directory.
Each dataset is saved with a standardized filename in the format of \verb{ces_<year>_<variant>.<format>},
where the format extension corresponds to the original dataset format (e.g., .sav for SPSS,
.dta for Stata). For ZIP archives, only the data files are extracted and saved, with all other
files (PDFs, etc.) discarded.
}
\examples{
\donttest{
# Download all CES datasets to a temporary directory
download_all_ces_datasets(path = tempdir(), overwrite = TRUE)

# Download only specific years (all variants for those years)
download_all_ces_datasets(years = c("2015", "2019", "2021"), path = tempdir(), overwrite = TRUE)

# Download only web surveys for 2015 and 2019
download_all_ces_datasets(years = c("2015", "2019"), variants = "web", 
                         path = tempdir(), overwrite = TRUE)

# Download to a temporary directory with overwrite
download_all_ces_datasets(path = tempdir(), overwrite = TRUE)
}

}
