% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{staggered}
\alias{staggered}
\title{Staggered Version of a Function}
\usage{
staggered(measure, ...)
}
\arguments{
\item{measure}{a track measure (see \link{TrackMeasures}).}

\item{...}{further parameters passed on to \code{\link{applyStaggered}}.}
}
\value{
Returns a function that computes
the given measure in a staggered fashion on that track.
}
\description{
Returns the "staggered" version of a track measure. That is, instead of
computing the measure on the whole track, the measure is averaged over
all subtracks (of any length) of the track.
}
\details{
This is a wrapper mainly designed to provide a convenient interface
for track-based staggered computations with \code{lapply}, see example.
}
\examples{
hist( sapply( TCells, staggered( displacement ) ) )

}
\references{
Zeinab Mokhtari, Franziska Mech, Carolin Zitzmann, Mike Hasenberg, Matthias Gunzer
and Marc Thilo Figge (2013), Automated Characterization and
Parameter--Free Classification of Cell Tracks Based on Local Migration
Behavior. \emph{PLoS ONE} \bold{8}(12), e80808. doi:10.1371/journal.pone.0080808
}
