% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outcome_models.R
\name{outcome_phreg}
\alias{outcome_phreg}
\title{Outcome model for time-to-event end-points (proportional hazards)}
\usage{
outcome_phreg(
  data,
  lp = NULL,
  par = NULL,
  outcome.name = c("time", "status"),
  remove = c("id", "num"),
  model = NULL,
  cens.model = NULL,
  cens.lp = NULL,
  cens.par = NULL,
  ...
)
}
\arguments{
\item{data}{(data.table) Covariate data, usually the output of the covariate
model of a \link{Trial} object.}

\item{lp}{linear predictor (formula or function)}

\item{par}{optional list of model parameter}

\item{outcome.name}{names of outcome (time and censoring status)}

\item{remove}{Variables that will be removed from input \code{data} (if formula is
not specified).}

\item{model}{optional \link[mets:phreg]{mets::phreg} object}

\item{cens.model}{optional model for censoring mechanism}

\item{cens.lp}{censoring linear predictor argument (formula or function)}

\item{cens.par}{list of censoring model parameters}

\item{...}{Additional arguments to \link{outcome_lp}}
}
\value{
data.table
}
\description{
Outcome model for time-to-event end-points (proportional hazards)
}
\author{
Klaus Kähler Holst
}
