% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ard_tabulate.survey.design.R
\name{ard_tabulate.survey.design}
\alias{ard_tabulate.survey.design}
\title{ARD Categorical Survey Statistics}
\usage{
\method{ard_tabulate}{survey.design}(
  data,
  variables,
  by = NULL,
  statistic = everything() ~ c("n", "N", "p", "p.std.error", "n_unweighted",
    "N_unweighted", "p_unweighted"),
  denominator = c("column", "row", "cell"),
  fmt_fun = NULL,
  stat_label = everything() ~ list(p = "\%", p.std.error = "SE(\%)", deff =
    "Design Effect", n_unweighted = "Unweighted n", N_unweighted = "Unweighted N",
    p_unweighted = "Unweighted \%"),
  fmt_fn = deprecated(),
  ...
)
}
\arguments{
\item{data}{(\code{survey.design})\cr
a design object often created with \code{\link[survey:svydesign]{survey::svydesign()}}.}

\item{variables}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
columns to include in summaries.}

\item{by}{(\code{\link[dplyr:dplyr_tidy_select]{tidy-select}})\cr
results are calculated for \strong{all combinations} of the column specified
and the variables. A single column may be specified.}

\item{statistic}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a character vector of
statistic names to include. See default value for options.}

\item{denominator}{(\code{string})\cr
a string indicating the type proportions to calculate. Must be one of
\code{"column"} (the default), \code{"row"}, and \code{"cell"}.}

\item{fmt_fun}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas,
or a single formula where the list element is a named list of functions
(or the RHS of a formula),
e.g. \verb{list(mpg = list(mean = \\(x) round(x, digits = 2) |> as.character()))}.}

\item{stat_label}{(\code{\link[cards:syntax]{formula-list-selector}})\cr
a named list, a list of formulas, or a single formula where
the list element is either a named list or a list of formulas defining the
statistic labels, e.g. \code{everything() ~ list(mean = "Mean", sd = "SD")} or
\code{everything() ~ list(mean ~ "Mean", sd ~ "SD")}.}

\item{fmt_fn}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}

\item{...}{These dots are for future extensions and must be empty.}
}
\value{
an ARD data frame of class 'card'
}
\description{
Compute tabulations on survey-weighted data.

The counts and proportion (\code{"N"}, \code{"n"}, \code{"p"}) are calculated using \code{survey::svytable()},
and the standard errors and design effect (\code{"p.std.error"}, \code{"deff"}) are
calculated using \code{survey::svymean()}.

The design effect (\code{"deff"}) is calculated only when requested in the \code{statistic} argument.

The unweighted statistics are calculated with \code{cards::ard_tabulate.data.frame()}.
}
\examples{
\dontshow{if (cardx:::is_pkg_installed("survey")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
svy_titanic <- survey::svydesign(~1, data = as.data.frame(Titanic), weights = ~Freq)

ard_tabulate(svy_titanic, variables = c(Class, Age), by = Survived)
\dontshow{\}) # examplesIf}
}
