% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CARA_function.R
\name{WBR_Alloc}
\alias{WBR_Alloc}
\title{Allocation Function of Weighted Balance Ratio Design for Binary and Continuous Response}
\usage{
WBR_Alloc(
  ptsb.X,
  ptsb.Z,
  ptsb.Y,
  ptsb.t,
  ptnow.X,
  ptnow.Z,
  weight,
  v = 2,
  response
)
}
\arguments{
\item{ptsb.X}{a vector of length \code{n} of the predictive covariates of previous patients. Must be binary.}

\item{ptsb.Z}{a \code{n x k}  of the prognostic covariates of previous patients. Must be binary.}

\item{ptsb.Y}{a vector of length \code{n} of the responses of previous patients.}

\item{ptsb.t}{a vector of length \code{n} of the treatment allocation of previous patients.}

\item{ptnow.X}{a binary value of the predictive covariate of the present patient.}

\item{ptnow.Z}{a vector of length \code{k} of the binary prognostic covariate of the present patient.}

\item{weight}{a vector of length \code{2+k}. The weight of balance ratio in overall,margin and stratum levels.}

\item{v}{a positive value that controls the randomness of allocation probability function.}

\item{response}{the type of the response. Options are \code{"Binary"} or \code{"Cont"}.}
}
\value{
\item{prob}{Probability of assigning the upcoming patient to treatment A.}
}
\description{
Calculating the probability of assigning the upcoming patient to treatment A based on the patient's covariates and the previous patients' covariates and responses for Weighted Balance Ratio procedure for binary and continuous response.
}
\details{
This function implements a covariate-adjusted response-adaptive design using a weighted balancing ratio rule (WBR) combined with a DBCD-type allocation function.

The first two steps follow Zhao et al. (2022): the first \eqn{2K} patients are randomized using restricted randomization with \eqn{K} patients in each treatment group. For patient \eqn{n > 2K}, suppose the prognostic covariates \eqn{\boldsymbol{Z}_n} fall into stratum \eqn{(k_1^*, \ldots, k_J^*)}.

Define the weighted imbalance ratio \eqn{\boldsymbol{r}_{n-1}(\boldsymbol{X}_n)} for patient \eqn{n} as:
\deqn{
\boldsymbol{r}_{n-1}(\boldsymbol{X}_n) =
w_o \frac{\boldsymbol{N}_{n-1}(\boldsymbol{X}_n)}{N_{n-1}(\boldsymbol{X}_n)} +
\sum_{j=1}^{J} w_{m,j} \frac{\boldsymbol{N}_{(j; k_j^*), n-1}(\boldsymbol{X}_n)}{N_{(j; k_j^*), n-1}(\boldsymbol{X}_n)} +
w_s \frac{\boldsymbol{N}_{(k_1^*, \ldots, k_J^*), n-1}(\boldsymbol{X}_n)}{N_{(k_1^*, \ldots, k_J^*), n-1}(\boldsymbol{X}_n)},
}
where \eqn{w_o}, \eqn{w_{m,1}}, \ldots, \eqn{w_{m,J}}, \eqn{w_s} are non-negative weights that sum to 1.

Based on the patient’s covariates, the target allocation probability \eqn{\hat{\rho}_{n-1}(\boldsymbol{X}_n)} is estimated from previous data.

The final probability of assigning patient \eqn{n} to treatment \eqn{k} is computed using a CARA-type allocation function from Hu and Zhang (2009):
\deqn{
\phi_{n,k}(\boldsymbol{X}_n) = g_k(\boldsymbol{r}_{n-1}(\boldsymbol{X}_n), \hat{\rho}_{n-1}(\boldsymbol{X}_n)) =
\frac{ \hat{\rho}_{n-1} \left( \frac{\hat{\rho}_{n-1}}{r_{n-1}} \right)^v }
{ \hat{\rho}_{n-1} \left( \frac{\hat{\rho}_{n-1}}{r_{n-1}} \right)^v + (1 - \hat{\rho}_{n-1}) \left( \frac{1 - \hat{\rho}_{n-1}}{1 - r_{n-1}} \right)^v },
}
where \eqn{v \geq 0} is a tuning parameter controlling the degree of randomness. A value of \eqn{v = 2} is commonly recommended.

This approach combines stratified covariate balancing with covariate-adjusted optimal targeting. More details can be found in Yu(2025).
}
\examples{
set.seed(123)

# Generate historical data for 400 patients
ptsb.X = sample(c(1, -1), 400, replace = TRUE)  # predictive covariate
ptsb.Z = cbind(
  sample(c(1, -1), 400, replace = TRUE),         # prognostic covariate 1
  sample(c(1, -1), 400, replace = TRUE)          # prognostic covariate 2
)
ptsb.Y = sample(c(1, 0), 400, replace = TRUE)   # binary responses
ptsb.t = sample(c(1, 0), 400, replace = TRUE)   # treatment assignments

# Incoming patient covariates
ptnow.X = 1
ptnow.Z = c(1, -1)

# Calculate allocation probability using WBR method
result = WBR_Alloc(
  ptsb.X = ptsb.X,
  ptsb.Z = ptsb.Z,
  ptsb.Y = ptsb.Y,
  ptsb.t = ptsb.t,
  ptnow.X = ptnow.X,
  ptnow.Z = ptnow.Z,
  weight = rep(0.25, 4),
  response = "Binary"
)

# View probability of assigning to treatment A
result$prob
}
\references{
Yu, J. (2025). A New Family of Covariate-Adjusted Response-Adaptive Randomization Procedures for Precision Medicine (Doctoral dissertation, The George Washington University).
}
\concept{Weighted Balance Ratio Design}
