% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uc-tables.R
\name{db_uc_tables_summaries}
\alias{db_uc_tables_summaries}
\title{List Table Summaries (Unity Catalog)}
\usage{
db_uc_tables_summaries(
  catalog,
  schema_name_pattern = NULL,
  table_name_pattern = NULL,
  max_results = 10000,
  include_manifest_capabilities = FALSE,
  page_token = NULL,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{catalog}{Name of parent catalog for tables of interest.}

\item{schema_name_pattern}{A sql \code{LIKE} pattern (\verb{\%} and \verb{_}) for schema
names. All schemas will be returned if not set or empty.}

\item{table_name_pattern}{A sql \code{LIKE} pattern (\verb{\%} and \verb{_}) for table names.
All tables will be returned if not set or empty.}

\item{max_results}{Maximum number of summaries for tables to return
(default: 10000, max: 10000). If not set, the page length is set to a server
configured value.}

\item{include_manifest_capabilities}{Whether to include a manifest containing
capabilities the table has.}

\item{page_token}{Opaque token used to get the next page of results. Optional.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\value{
List
}
\description{
List Table Summaries (Unity Catalog)
}
\seealso{
Other Unity Catalog Table Management: 
\code{\link{db_uc_tables_delete}()},
\code{\link{db_uc_tables_exists}()},
\code{\link{db_uc_tables_get}()},
\code{\link{db_uc_tables_list}()}
}
\concept{Unity Catalog Table Management}
