% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_df.R
\name{sim_df}
\alias{sim_df}
\title{Create a spatial interaction models data frame from a collection of
interaction models}
\usage{
sim_df(x, sim_column = "sim")
}
\arguments{
\item{x}{a collection of spatial interaction models, an object of class
\code{sim_list}}

\item{sim_column}{the name of the \code{sim_list} column (default \code{"sim"})}
}
\value{
a data frame representation of the spatial interaction model
collection with classes \code{sim_df} and \code{data.frame}
}
\description{
This function build a data frame from a collection of spatial interaction
models. The data frame has a list column \code{sim} of type \code{sim_list} which
stores the collection of models and classical columns that contain
characteristics of the models. The name of the list column can be set to
something else than \code{sim} (but not a name used by other default columns). See
details for the default columns.
}
\details{
The data frame has one row per spatial interaction model and the following
columns:
\itemize{
\item \code{sim} (default name): the last column that contains the models
\item \code{alpha}: the return to scale parameter used to build the model
\item \code{beta}: the cost inverse scale parameter used to build the model
\item \code{diversity}: model default \code{\link[=diversity]{diversity()}} (Shannon's diversity)
\item \code{iterations}: the number of iterations used to produce the model (1 for a
static model)
\item \code{converged}: \code{TRUE} is the iterative calculation of the model converged
(for models produced by \code{\link[=blvim]{blvim()}} and related approaches), \code{FALSE} for no
convergence and \code{NA} for static models
}

The resulting object behaves mostly like a \code{data.frame} and support standard
extraction and replacement operators. The object tries to keep its \code{sim_df}
class during modifications. In particular, \code{names<-.sim_df()} tracks
name change for the \code{sim_list} column. If a modification or an extraction
operation changes the type of the \code{sim_list} column or drops it, the
resulting object is a standard \code{data.frame}. See \code{\link{[.sim_df}}
and \code{\link[=names<-.sim_df]{names<-.sim_df()}} for details.
}
\examples{
distances <- french_cities_distances[1:10, 1:10] / 1000 ## convert to km
production <- rep(1, 10)
attractiveness <- log(french_cities$area[1:10])
all_flows <- grid_blvim(distances, production, seq(1.05, 1.45, by = 0.2),
  seq(1, 3, by = 0.5) / 400,
  attractiveness,
  bipartite = FALSE,
  epsilon = 0.1, iter_max = 1000,
)
all_flows_df <- sim_df(all_flows)
all_flows_df$converged
## change the name of the sim column
names(all_flows_df)[6] <- "models"
## still a sim_df
class(all_flows_df)
## get the models
sim_column(all_flows_df)
}
