% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-biomass.r
\docType{data}
\name{biomass}
\alias{biomass}
\title{Contains tree-level biomass data for four species in Canada.}
\format{
Data contain the following columns:
\describe{
\item{tree}{Tree number code.}
\item{spp}{Species common name, as follows: \verb{Balsam fir} is
\emph{Abies balsamea}, \verb{Black spruce} is \emph{Picea mariana},
\verb{White birch} is \emph{Betula papyrifera}, and \verb{White spruce}
is \emph{Picea glauca}.}
\item{dbh}{Diameter at breast height, in cm.}
\item{toth}{Total height, in m.}
\item{totbiom}{Total biomass, in kg.}
\item{bolebiom}{Stem biomass, in kg.}
\item{branchbiom}{Branches biomass, in kg.}
\item{foliagebiom}{Foliage biomass, in kg.}
}
}
\source{
Data were provided by Prof. Timothy Gregoire, School of Forestry
and Environmental Studies, Yale University (New Haven, CT, USA).
}
\usage{
biomass
}
\description{
These are tree-level variables for four species in Canada.
}
\examples{
data(biomass)
head(biomass)
tapply(biomass$totbiom,biomass$spp,summary)
}
\keyword{datasets}
