% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pls_analysis.R
\name{pls_select_components}
\alias{pls_select_components}
\title{Component selection via information criteria}
\usage{
pls_select_components(
  object,
  X,
  Y,
  criteria = c("aic", "bic"),
  max_comp = NULL
)
}
\arguments{
\item{object}{A fitted PLS model.}

\item{X}{Training design matrix.}

\item{Y}{Training response matrix or vector.}

\item{criteria}{Character vector specifying which criteria to compute.}

\item{max_comp}{Maximum number of components to consider.}
}
\value{
A list with the per-component table and the selected components.
}
\description{
Component selection via information criteria
}
\examples{
set.seed(123)
X <- matrix(rnorm(60), nrow = 20)
y <- X[, 1] - 0.5 * X[, 2] + rnorm(20, sd = 0.1)
fit <- pls_fit(X, y, ncomp = 2, scores = "r")
pls_select_components(fit, X, y)
}
