% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{runMCMC}
\alias{runMCMC}
\title{Run Bayesian Transmission MCMC}
\usage{
runMCMC(
  data,
  modelParameters,
  nsims,
  nburn = 100L,
  outputparam = TRUE,
  outputfinal = FALSE,
  verbose = FALSE
)
}
\arguments{
\item{data}{Data frame with columns, in order: facility, unit, time, patient, and event type.}

\item{modelParameters}{List of model parameters, see \code{\link[=LogNormalModelParams]{LogNormalModelParams()}}.}

\item{nsims}{Number of MCMC samples to collect after burn-in.}

\item{nburn}{Number of burn-in iterations.}

\item{outputparam}{Whether to output parameter values at each iteration.}

\item{outputfinal}{Whether to output the final model state.}

\item{verbose}{Print progress messages.}
}
\value{
A list with the following elements:
\itemize{
\item \code{Parameters} the MCMC chain of model parameters (if outputparam=TRUE)
\item \code{LogLikelihood} the log likelihood of the model at each iteration (if outputparam=TRUE)
\item \code{MCMCParameters} the MCMC parameters used
\item \code{ModelParameters} the model parameters used
\item \code{ModelName} the name of the model
\item \code{nstates} the number of states in the model
\item \code{waic1} the WAIC1 estimate
\item \code{waic2} the WAIC2 estimate
\item and optionally (if outputfinal=TRUE) \code{FinalModel} the final model state.
}
}
\description{
Run Bayesian Transmission MCMC
}
\examples{
  # Minimal example: create parameters and run a very short MCMC
  params <- LinearAbxModel(nstates = 2)
  data(simulated.data_sorted, package = "bayestransmission")
  results <- runMCMC(
    data = simulated.data_sorted,
    modelParameters = params,
    nsims = 3,
    nburn = 0,
    outputparam = TRUE,
    outputfinal = FALSE,
    verbose = FALSE
  )
  str(results)
}
\seealso{
\link{mcmc_to_dataframe}
}
