% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{s_date_Eti}
\alias{s_date_Eti}
\title{Make Etiology design matrix for dates with R format.}
\usage{
s_date_Eti(Rdate, Y, basis = "ps", dof = ifelse(basis == "ncs", 5, 10), ...)
}
\arguments{
\item{Rdate}{a vector of dates of \code{R} format}

\item{Y}{Binary case/control status; \code{1} for case; \code{0} for controls}

\item{basis}{\code{ncs} for natural cubic splines; \code{ps} for penalized-splines based
on B-spline basis functions (NB: baker does not recommend setting ncs using
this function; use splines::ns)}

\item{dof}{Degree-of-freedom for the bases. For \code{ncs} basis, \code{dof} is
the number of columns; For \code{ps} basis,  the number of columns is \code{dof}
if \code{intercept=TRUE}; \code{dof-1} if \code{FALSE}.}

\item{...}{Other arguments as in \code{\link[splines:bs]{splines::bs()}}}
}
\value{
\itemize{
\item \code{Z_Eti} design matrix for etiology regression on dates.
}
}
\description{
\code{s_date_Eti} creates design matrices for etiology regressions;
}
\examples{

data("data_nplcm_reg_nest")
s_date_Eti(data_nplcm_reg_nest$X$DATE,data_nplcm_reg_nest$Y,basis='ps',dof=7)
}
\seealso{
\code{\link[=nplcm]{nplcm()}}
}
