% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs-actions.R
\name{ecs_list_attributes}
\alias{ecs_list_attributes}
\title{List Attributes}
\usage{
ecs_list_attributes(
  maxResults = NULL,
  nextToken = NULL,
  cluster = NULL,
  targetType = NULL,
  attributeName = NULL,
  attributeValue = NULL,
  simplify = TRUE,
  others = list(),
  print_on_error = aws_get_print_on_error(),
  retry_time = aws_get_retry_time(),
  network_timeout = aws_get_network_timeout(),
  region = aws_get_region()
)
}
\arguments{
\item{maxResults}{Character. Pagination limit[optional]}

\item{nextToken}{Characters. The token for the next page of results[optional]}

\item{cluster}{Character. The short name or full Amazon Resource Name (ARN) of the cluster to list attributes.}

\item{targetType}{Character. The type of the target with which to list attributes.}

\item{attributeName}{Character. The name of the attribute with which to filter the results.}

\item{attributeValue}{Character. The value of the attribute with which to filter results.}

\item{simplify}{Logical. Whether to simplify the result and handle \code{nextToken}
in the response[optional]}

\item{others}{Named list. The parameters that are not included in the
function parameters and need to be added into the request[optional]}

\item{print_on_error}{Logical. Whether to show an error message when a
network error occurs.}

\item{retry_time}{Integer. Number of retries for a REST request when encounter the
network issue. If the request has been sent \code{retry_time} times but still not
be able to get the response, an error will be thrown.}

\item{network_timeout}{Numeric. Number of seconds to wait for a REST response
until giving up. Can not be less than 1 ms.}

\item{region}{Character. The region of the AWS service.}
}
\value{
A list object or a character vector
}
\description{
Lists the attributes for Amazon ECS
resources within a specified target type and cluster. When you specify a
target type and cluster, \code{ListAttributes} returns a list of attribute
objects, one for each attribute on each resource. You can filter the
list of results to a single attribute name to only return results that
have that name. You can also filter the results by attribute name and
value, for example, to see which container instances in a cluster are
running a Linux AMI (\code{ecs.os-type=linux}).
}
\section{maxResults}{

Pagination
limit
}

\section{cluster}{

The short
name or full Amazon Resource Name (ARN) of the cluster to list
attributes. If you do not specify a cluster, the default cluster is
assumed.
}

\section{targetType}{

The type of the target with which to list
attributes.
}

\section{attributeName}{

The name of the attribute with which to
filter the results.
}

\section{attributeValue}{

The value of the attribute with
which to filter results. You must also specify an attribute name to use
this parameter.
}

