% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nextsample.R
\name{nextsample}
\alias{nextsample}
\title{Draw a next (batch) of Monte-Carlo samples to update the sequential estimate
of the p-value}
\usage{
nextsample(R, compute_lower = FALSE)
}
\arguments{
\item{R}{an object of class \code{avseqmc_progress} containing previous progress on
the sequential estimation.}

\item{compute_lower}{TRUE if the lower limit of the confidence sequence of
significance epsilon (as embedded in parameter R) should be computed.}
}
\value{
An (updated) object of class \code{avseqmc_progress} containing the progress of the
sequentially estimated p-value. The object is a list containing the
following elements:
\itemize{
\item \verb{$epsilon}: risk of overestimated significance used in the sequential estimation.
\item \verb{$sample_G}: function that samples (batches) from the Monte-Carlo distribution $G^*(X)$ as in Equation (5).
\item \verb{$ptilde}: sequence of sequential $p$-value estimates. The final value in this sequence is the most recent estimate of the $p$-value.
\item \verb{$Ltilde}: sequence of lower bounds of the confidence sequence based on the construction by Robbins (1970). Contains NA values if these were
not computed by default through \code{stopcrit =  list("type"="futility","param"=...)} or requested using
\code{compute_lower=TRUE}.
\item \verb{$n}: total number of samples drawn from the MC sampler.
\item \verb{$S}: total number of ones observed from the MC sampler.
\item \verb{$B}: sequence of number of ones observed at each sampling timepoint (which can be greater than 1 if \code{sample_G} samples in batches)
\item \verb{$Bn}: sequence of number of samples drawn from MC sampler at each timepoint (which can be greater than 1 if \code{sample_G} samples in batches)
}
}
\description{
Draw a next (batch) of Monte-Carlo samples to update the sequential estimate
of the p-value
}
\keyword{internal}
