% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vendor.R
\name{vendor}
\alias{vendor}
\title{Vendor the cpp4r and armadillo4r headers}
\usage{
vendor(path = NULL)
}
\arguments{
\item{path}{The directory with the vendored headers. It is recommended to use `"./src/vendor"`.
The default is `NULL`.}
}
\value{
The path to the vendored code (invisibly).
}
\description{
Vendoring is the act of making your own copy of the 3rd party packages your
project is using. It is often used in the go language community.

This function vendors armadillo4r into your package by copying the armadillo4r
headers into the `inst/include` folder of your package and adding
'armadillo4r version: XYZ' to the top of the files, where XYZ is the version of
armadillo4r currently installed on your machine.

**Note**: vendoring places the responsibility of updating the code on
**you**. Bugfixes and new features in armadillo4r will not be available for your
code until you run `cpp_vendor()` again.
}
\examples{
# create a new directory
dir <- paste0(tempdir(), "/", gsub("\\\\s+|[[:punct:]]", "", Sys.time()))
dir.create(dir, recursive = TRUE)

# vendor the armadillo4r headers into the directory
vendor(dir)

# just a preview as Armadillo has over 100 files
head(list.files(dir, recursive = TRUE))

# cleanup
unlink(dir, recursive = TRUE)
}
