% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/05_get_geodata.R
\name{get_geodata}
\alias{get_geodata}
\title{Call a Large Language Model (LLM) to extract species geographic data}
\usage{
get_geodata(
  path,
  user_key,
  service = "GPT",
  model = "gpt-3.5",
  tax = NULL,
  outpath = NULL,
  outliers = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{character. string of a file with species data in either pdf or txt format, e.g: \code{"./folder/file.pdf"}}

\item{user_key}{list. Two elements, first element is a character with the user's API key, second element is a logical Bool determining whether the user's account has access to premium features.
Both free keys and premium keys are allowed.}

\item{service}{character. Model to be used. Right now, only requests using OpenAI's \code{chatGPT} are available.}

\item{model}{character. Model name from given service to be used. You may use any of the models listed on OpenAI's developer platform.
If you are unsure which model to use, we recommend picking \code{"gpt-3.5"} (default) or \code{"gpt-4o"}, as these will pick our recommended model from that version.}

\item{tax}{character. Binomial name of the species to specify extraction to. Most often increases performance of the model.}

\item{outpath}{Character string of a path to save output to in the format \code{"path/to/file/file_prefix"}.}

\item{outliers}{logical. Whether or not results should be processed using the methods described in \code{\link[gecko:outliers.detect]{gecko::outliers.detect()}}}

\item{verbose}{logical determining if output should be printed.}
}
\value{
matrix. Containing the extracted information.
}
\description{
Send an API request to extract species data from a document. 
For now only \code{service = "GPT"} is supported but more are planned including
both proprietary and open source models. Uses the API...
}
\examples{
\dontrun{
file_path = arete_data("holzapfelae")

get_geodata(
  path = file_path,
  user_key = list(key = "your key here", premium = TRUE),
  model = "gpt-4o",
  outpath = "./out"
)}
}
\seealso{
\code{\link{arete_setup}}
}
