% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shiny-input.R
\name{set_input_selection}
\alias{set_input_selection}
\title{Retrieve selection information in Shiny}
\usage{
set_input_selection(
  ax,
  inputId,
  type = c("x", "xy", "y"),
  fill_color = "#24292e",
  fill_opacity = 0.1,
  stroke_width = 1,
  stroke_dasharray = 3,
  stroke_color = "#24292e",
  stroke_opacity = 0.4,
  xmin = NULL,
  xmax = NULL,
  ymin = NULL,
  ymax = NULL,
  session = shiny::getDefaultReactiveDomain()
)
}
\arguments{
\item{ax}{An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.}

\item{inputId}{The id that will be used server-side for retrieving selection.}

\item{type}{Allow selection either on x-axis, y-axis or on both axis.}

\item{fill_color}{Background color of the selection rect which is drawn when user drags on the chart.}

\item{fill_opacity}{Opacity of background color of the selection rectangle.}

\item{stroke_width}{Border thickness of the selection rectangle.}

\item{stroke_dasharray}{Creates dashes in borders of selection rectangle.
Higher number creates more space between dashes in the border.}

\item{stroke_color}{Colors of selection border.}

\item{stroke_opacity}{Opacity of selection border.}

\item{xmin, xmax}{Start value of x-axis. Both \code{min} and \code{max} must be provided.}

\item{ymin, ymax}{Start value of y-axis. Both \code{min} and \code{max} must be provided.}

\item{session}{The Shiny session.}
}
\value{
An \code{\link[=apexchart]{apexchart()}} \code{htmlwidget} object.
}
\description{
Retrieve selection information in Shiny
}
\examples{

library(apexcharter)
data("economics", package = "ggplot2")

# Not in Shiny so no events
# but you can still select an area on chart
apex(economics, aes(date, psavert), type = "line") \%>\% 
  set_input_selection("selection")

# Default selection at start
apex(economics, aes(date, psavert), type = "line") \%>\% 
  set_input_selection(
    inputId = "selection", 
    xmin = format_date("1980-01-01"), 
    xmax = format_date("1985-01-01")
  )
}
