% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apex-options.R
\name{radialBar_opts}
\alias{radialBar_opts}
\title{Radial bar options}
\usage{
radialBar_opts(
  size = NULL,
  inverseOrder = NULL,
  startAngle = NULL,
  endAngle = NULL,
  offsetX = NULL,
  offsetY = NULL,
  hollow = NULL,
  track = NULL,
  dataLabels = NULL,
  ...
)
}
\arguments{
\item{size}{Numeric. Manual size of the radialBars instead of calculating automatically from default height / width.}

\item{inverseOrder}{Logical. Whether to make the first value of series innermost or outermost.}

\item{startAngle}{Numeric. Angle from which the radialBars should start.}

\item{endAngle}{Numeric. Angle to which the radialBars should end. The sum of the startAngle and endAngle should not exceed 360.}

\item{offsetX}{Numeric. Sets the left offset for radialBars.}

\item{offsetY}{Numeric. Sets the top offset for radialBars.}

\item{hollow}{List.}

\item{track}{List.}

\item{dataLabels}{List.}

\item{...}{Additional parameters.}
}
\value{
A \code{list} of options that can be used in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\description{
Use these options in \code{\link[=ax_plotOptions]{ax_plotOptions()}}.
}
\note{
See \url{https://apexcharts.com/docs/options/plotoptions/radialbar/}.
}
\examples{
apexchart() \%>\% 
  ax_chart(type = "radialBar") \%>\% 
  ax_plotOptions(
    radialBar = radialBar_opts(
      startAngle = -135,
      endAngle = 135,
      dataLabels = list(
        name = list(
          fontSize = "16px",
          # color = undefined,
          offsetY = 120
        ),
        value = list(
          offsetY = 76,
          fontSize = "22px",
          # color = undefined,
          formatter = htmlwidgets::JS("function (val) {return val + '\%';}")
        )
      )
    )
  ) \%>\% 
  ax_stroke(dashArray = 4) \%>\% 
  ax_series(70) \%>\% 
  ax_labels("Indicator")
}
