% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{mse.mle}
\alias{mse.mle}
\title{Computes the MSE of an `mle` object.}
\usage{
\method{mse}{mle}(x, theta = NULL)
}
\arguments{
\item{x}{the `mle` object to compute the MSE of.}

\item{theta}{true parameter value, defaults to `NULL` for unknown. If `NULL`,
then we let the bias method deal with it. Maybe it has a nice way
of estimating the bias.}
}
\value{
The MSE as a scalar (univariate) or matrix (multivariate).
}
\description{
The MSE of an estimator is just the expected sum of squared differences,
e.g., if the true parameter value is `x` and we have an estimator `x.hat`,
then the MSE is
```
    mse(x.hat) = E[(x.hat-x) %*% t(x.hat - x)] =
                      vcov(x.hat) + bias(x.hat, x) %*% t(bias(x.hat, x))
```
}
\details{
Since `x` is not typically known, we normally must estimate the bias.
Asymptotically, assuming the regularity conditions, the bias of an MLE
is zero, so we can estimate the MSE as `mse(x.hat) = vcov(x.hat)`, but for
small samples, this is not generally the case. If we can estimate the bias, then
we can replace the bias with an estimate of the bias.

Sometimes, we can estimate the bias analytically, but if not, we can use something
like the bootstrap. For example, if we have a sample of size `n`, we can bootstrap
the bias by sampling `n` observations with replacement, computing the MLE, and
then computing the difference between the bootstrapped MLE and the MLE. We can
repeat this process `B` times, and then average the differences to get an estimate
of the bias.
}
