% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gnr_df.r
\name{gnr_df}
\alias{gnr_df}
\title{Wrapper function to apply gnr_simple across a data.frame or list of species
names. Modified on 11/18/2025 by Vijay Patil (vpatil@usgs.gov) for
algaeClassify v2.0.5 (pending approval on CRAN).}
\usage{
gnr_df(
  df,
  name.column,
  sourceid = NULL,
  fuzzy_uninomial = TRUE,
  name_type = "canonical_full",
  higher = FALSE
)
}
\arguments{
\item{df}{data.frame containing names to check}

\item{name.column}{integer or character string with column name containing
species names}

\item{sourceid}{integer vector with data source ids.
see https://resolver.globalnames.org/sources/}

\item{fuzzy_uninomial}{boolean. Use fuzzy matching for uninomial names?}

\item{name_type}{Specify format of matched names. Options are
'canonical_simple' (canonical binomial name), 'canonical_full' (with subspecies
or subgenera), or 'with_context' (with author and year appended).}

\item{higher}{boolean: Return higher taxonomic classifications?}
}
\value{
new data.frame original names (input_name), information about match
type,the best match (match_name), taxonomic status, and other output from
gnr_simple(). Will contain a row of NAs if no matches were found for a name.
}
\description{
Provides convienent output with a row per name, to streamline merging with
original data.
}
\examples{
data(lakegeneva)
#example dataset with 50 rows

lakegeneva<- genus_species_extract(lakegeneva,'phyto_name')
lakegeneva$genus_species <- trimws(paste(lakegeneva$genus,
lakegeneva$species))

#checking for matches from all GNRS sources, first 5 rows:
lakegeneva.namematches <- gnr_df(lakegeneva,"genus_species")
lakegeneva.namematches
}
