% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_data.R
\name{verify_parameters}
\alias{verify_parameters}
\title{Conditionally Verify and Override PK Parameters Based on Sample Type}
\usage{
verify_parameters(pknca_intervals, params, all_pknca_params)
}
\arguments{
\item{pknca_intervals}{A data frame containing PKNCA interval information,
including pharmacokinetic parameters and a \code{PCSPEC} column that describes the
specimen type.}

\item{params}{A character vector of parameter names selected by the user.
Only these parameters will remain \code{TRUE} for excreta types.}

\item{all_pknca_params}{A character vector of all pharmacokinetic parameters
that may be present in \code{pknca_intervals}. These will be checked and updated accordingly.}
}
\value{
A modified version of the \code{pknca_intervals} data frame with appropriate
parameters updated based on the specimen type.
}
\description{
This helper function updates a PKNCA intervals data frame by verifying and overriding
specific pharmacokinetic parameters depending on whether the sample is identified
as excreta (e.g., urine, feces, bile). Parameters related to excretion
(such as \code{ae}, \code{fe}, and those starting with \code{"clr."}) are selectively enabled
only for excreta samples and set to \code{FALSE} otherwise.
}
