% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversions.R
\name{convert_volume_units}
\alias{convert_volume_units}
\title{Convert Volume Units to Match Concentration Denominator Units}
\usage{
convert_volume_units(
  df,
  avalu = "AVALU",
  volume = "VOLUME",
  volumeu = "VOLUMEU"
)
}
\arguments{
\item{df}{A data frame containing pharmacokinetic data.}

\item{avalu}{A character string specifying the column name for
concentration values (default: "AVALU").}

\item{volume}{A character string specifying the column name for
volume or mass values (default: "VOLUME").}

\item{volumeu}{A character string specifying the column name for
volume or mass units (default: "VOLUMEU").
It must contain the following columns:
\describe{
\item{PCSPEC}{Sample type (e.g., urine, feces, bile, plasma).}
\item{AVAL}{Concentration values.}
\item{AVALU}{Concentration units (e.g., "ug/mL", "mg/g").}
\item{VOLUME}{Volume or mass values for integration.}
\item{VOLUMEU}{Units for the \code{VOLUME} column (e.g., "mL", "g").}
}}
}
\value{
A modified data frame with \code{VOLUME} and \code{VOLUMEU} converted (where necessary)
so that multiplying \code{AVAL * VOLUME} results in a unit with consistent dimensionality
(typically mass or moles).
A new column \code{AMOUNTU} is created to represent the product of \code{AVALU} and \code{VOLUMEU}.
}
\description{
This function identifies rows associated with excretion samples (e.g., urine, feces, bile)
and adjusts the \code{VOLUME} and \code{VOLUMEU} columns so that the volume unit matches the
denominator unit in the corresponding concentration unit (\code{AVALU}).
This is necessary for PKNCA calculation of excretion parameters.
}
\details{
It uses the \pkg{units} package to perform unit-safe conversions. If a direct conversion
between volume and the concentration denominator is not possible (e.g., between mass and volume),
a fallback conversion is attempted using a neutral density of \code{1 (target_unit / original_unit)}.
The function modifies only the \code{VOLUME} and \code{VOLUMEU} columns when necessary and leaves all
other data unchanged.

The function:
\enumerate{
\item Parses the denominator from \code{AVALU} (e.g., "ug/mL" → "mL").
\item Attempts to convert the corresponding \code{VOLUME} to that unit.
\item If direct conversion fails, assumes a neutral density of 1
(i.e., \verb{1 unit_target / unit_original}) and retries.
\item Leaves units unchanged for non-excreta samples or already-valid combinations.
}

The function assumes that the \code{AVALU} column contains concentration units
in the form of "x/y" (e.g., "ug/mL", "mg/g").
}
\examples{
df <- data.frame(
  PCSPEC = c("urine", "feces", "plasma"),
  AVAL = c(100, 5, 70),
  AVALU = c("ug/mL", "mg/g", "ng/mL"),
  VOLUME = c(2, 1.5, 3),
  VOLUMEU = c("L", "mL", "mL"),
  stringsAsFactors = FALSE
)

df_converted <- convert_volume_units(df)

}
