% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_config_chart.R
\name{generate_cross_threshold_chart}
\alias{generate_cross_threshold_chart}
\title{Generate cross-threshold configuration chart from sweep results}
\usage{
generate_cross_threshold_chart(
  result,
  conditions = NULL,
  symbol_set = c("unicode", "ascii", "latex"),
  chart_level = c("term", "summary"),
  language = c("en", "ja")
)
}
\arguments{
\item{result}{A result object from any Sweep function (otSweep, ctSweepS,
ctSweepM, or dtSweep).}

\item{conditions}{Character vector. Condition names for row ordering.
If NULL, automatically extracted from expressions.}

\item{symbol_set}{Character. One of \code{"unicode"}, \code{"ascii"}, 
or \code{"latex"}. Default is \code{"unicode"}.}

\item{chart_level}{Character. Chart aggregation level:
\code{"term"} (default) produces solution-term level charts following Fiss (2011)
notation, where each column represents one prime implicant.
\code{"summary"} produces threshold-level summaries where
each column represents one threshold, aggregating all configurations.}

\item{language}{Character. \code{"en"} for English, \code{"ja"} for Japanese.}
}
\value{
Character string containing Markdown-formatted table.
}
\description{
Creates a configuration chart from threshold sweep results. Supports
two levels of aggregation: solution-term level (Fiss-style, default) and
threshold-level summary.
}
\examples{
\dontrun{
data(sample_data)
result <- otSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:8,
  thrX = c(X1 = 7, X2 = 7, X3 = 7)
)

# Solution-term level, Fiss-style (default)
chart <- generate_cross_threshold_chart(result, c("X1", "X2", "X3"))
cat(chart)

# Threshold-level summary
chart <- generate_cross_threshold_chart(result, c("X1", "X2", "X3"),
                                         chart_level = "summary")
cat(chart)
}
}
