% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_helpers.R
\name{format_qca_term}
\alias{format_qca_term}
\title{Format a single QCA term}
\usage{
format_qca_term(term, var_names, use_tilde = TRUE)
}
\arguments{
\item{term}{Character. A single term (e.g., "KSPRVT" or "~KPR*PRD").}

\item{var_names}{Character vector. Variable names used in the analysis.}

\item{use_tilde}{Logical. If TRUE, negation is represented as \code{~VAR}.
If FALSE, negation is represented as lowercase (e.g., \code{var}).}
}
\value{
Character. The formatted term with \code{*} between all variables.
}
\description{
Inserts \code{*} between variables in a term where it may have been omitted.
}
\examples{
var_names <- c("KSP", "KPR", "PRD", "RVT", "RCM")
format_qca_term("KSPRVTRCM", var_names)
# Returns: "KSP*RVT*RCM"

format_qca_term("~KPRPRD", var_names)
# Returns: "~KPR*PRD"
}
