% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_ots_dts.R
\name{otSweep}
\alias{otSweep}
\title{OTS–QCA: Outcome threshold sweep}
\usage{
otSweep(
  dat,
  Yvar,
  Xvars,
  sweep_range,
  thrX,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 2,
  pri.cut = 0.5,
  return_details = FALSE
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{Yvar}{Character. Outcome variable name.}

\item{Xvars}{Character vector. Names of condition variables.}

\item{sweep_range}{Numeric vector. Candidate thresholds for Y.}

\item{thrX}{Named numeric vector. Fixed thresholds for X variables,
with names matching \code{Xvars}.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize}.}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{return_details}{Logical. If \code{TRUE}, returns both summary
and detailed objects.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{thrY} — threshold for Y
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — per-Y-threshold list of
\code{thrY}, \code{thrX_vec}, \code{truth_table}, \code{solution}
}
}
\description{
Sweeps the threshold of the outcome Y while keeping the thresholds of
all X conditions fixed.
}
\examples{
# Load sample data
data(sample_data)

# Set fixed thresholds for conditions
thrX <- c(X1 = 7, X2 = 7, X3 = 7)

# Run outcome threshold sweep
result <- otSweep(
  dat = sample_data,
  Yvar = "Y",
  Xvars = c("X1", "X2", "X3"),
  sweep_range = 6:9,
  thrX = thrX
)
head(result)
}
