% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_cts.R
\name{ctSweepS}
\alias{ctSweepS}
\title{CTS–QCA: Single-condition threshold sweep}
\usage{
ctSweepS(
  dat,
  Yvar,
  Xvars,
  sweep_var,
  sweep_range,
  thrY,
  thrX_default = 7,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 2,
  pri.cut = 0.5,
  return_details = FALSE
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{Yvar}{Character. Outcome variable name.}

\item{Xvars}{Character vector. Names of condition variables.}

\item{sweep_var}{Character. Name of the condition to be swept.
Must be one of \code{Xvars}.}

\item{sweep_range}{Numeric vector. Candidate thresholds for \code{sweep_var}.}

\item{thrY}{Numeric. Threshold for Y (fixed).}

\item{thrX_default}{Numeric. Default threshold for non-swept X variables.}

\item{dir.exp}{Optional named numeric vector of directional expectations
for \code{\link[QCA]{minimize}}. If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize} (e.g., \code{"?"}).}

\item{incl.cut}{Consistency cutoff for \code{\link[QCA]{truthTable}}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{return_details}{Logical. If \code{TRUE}, returns both a summary
data frame and detailed objects for each threshold.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{threshold} — swept threshold for \code{sweep_var}
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — per-threshold list of
\code{threshold}, \code{thrX_vec}, \code{truth_table}, \code{solution}
}
}
\description{
Performs a threshold sweep for one focal condition X. For each threshold
in \code{sweep_range}, the outcome Y and all X variables are binarized
using user-specified thresholds, and a crisp-set QCA is executed.
}
\examples{
# Load sample data
data(sample_data)

# Run single condition threshold sweep on X3
result <- ctSweepS(
  dat = sample_data,
  Yvar = "Y",
  Xvars = c("X1", "X2", "X3"),
  sweep_var = "X3",
  sweep_range = 6:8,
  thrY = 7,
  thrX_default = 7
)
head(result)
}
