% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features_07_claim_payment_time.R
\name{claim_payment_delay}
\alias{claim_payment_delay}
\title{Inter-Partial Delays}
\usage{
claim_payment_delay(
  frequency_vector,
  claim_size_list,
  no_payments_list,
  settlement_list,
  rfun,
  paramfun,
  ...
)
}
\arguments{
\item{frequency_vector}{a vector of claim frequencies for all the periods.}

\item{claim_size_list}{list of claim sizes.}

\item{no_payments_list}{list of number of partial payments.}

\item{settlement_list}{list of settlement delays.}

\item{rfun}{optional alternative random sampling function; see Details for
default.}

\item{paramfun}{parameters for the random sampling function, as a function of
\code{claim_size}, \code{setldel}; see Details.}

\item{...}{other arguments/parameters to be passed onto \code{paramfun}.}
}
\description{
Simulates and returns the inter-partial delays (i.e. the delay of one
partial payment relative to the previous) of each payment for each of the
claims occurring in each of the periods.
}
\details{
Returns a compound list structure such that the \eqn{j}th component
of the \eqn{i}th sub-list gives the payment delay pattern (as a vector) for
the \eqn{j}th claim of occurrence period \eqn{i}.

The default \code{rfun} is split into 2 cases.

\strong{Case 1: claims with at least 4 partial payments.} The simulation takes
2 steps.
First we sample the last payment delay from a Weibull distribution with
mean = 1 quarter (automatically converted to the relevant \code{time_unit}, a
global variable that the user is required to define at the top of their code)
and CoV = 20\%. Then we sample the remaining payment delays from a second
Weibull distribution with CoV at 35\% and mean = target mean settlement delay
(see \code{\link{claim_closure}}) divided by the number of payments.

\strong{Case 2: claims with less than 4 partial payments.} Proceed as in Case 1
but without separating out the simulation of the last payment delay (i.e.
ignore step 1).
}
\examples{
# set up
n_vector <- claim_frequency(I = 10)
claim_sizes <- claim_size(n_vector)
no_payments <- claim_payment_no(n_vector, claim_sizes)
setldel <- claim_closure(n_vector, claim_sizes)

# with default setting
pmtdel <- claim_payment_delay(n_vector, claim_sizes, no_payments, setldel)
pmtdel[[1]][[1]] # payment delays for claim 1 of occurrence period 1

# with some custom rfun
# simplistic case: payments times are uniformly distributed
my_func <- function(n, setldel) {
  prop <- runif(n)
  prop <- prop / sum(prop)
  setldel * prop
}
mypayments <- claim_payment_delay(n_vector, claim_sizes, no_payments, setldel,
                                  rfun = my_func)
# inter-partial delays for claim 1 of occurrence period 1
mypayments[[1]][[1]]
}
