% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osrm_start_server.R
\name{osrm_start_server}
\alias{osrm_start_server}
\title{Start an OSRM MLD/CH server with \code{osrm-routed}}
\usage{
osrm_start_server(
  osrm_path,
  version = FALSE,
  help = FALSE,
  verbosity = c("INFO", "ERROR", "WARNING", "NONE", "DEBUG"),
  trial = FALSE,
  ip = "0.0.0.0",
  port = 5001L,
  threads = 8L,
  shared_memory = FALSE,
  memory_file = NULL,
  mmap = FALSE,
  dataset_name = NULL,
  algorithm = NULL,
  max_viaroute_size = 500L,
  max_trip_size = 100L,
  max_table_size = 100L,
  max_matching_size = 100L,
  max_nearest_size = 100L,
  max_alternatives = 3L,
  max_matching_radius = -1L,
  quiet = FALSE,
  verbose = FALSE,
  echo_cmd = FALSE
)
}
\arguments{
\item{osrm_path}{Character(1). Path to the \code{.osrm.mldgr} or \code{.osrm.hsgr} file}

\item{version}{Logical; if \code{TRUE}, prints version and exits}

\item{help}{Logical; if \code{TRUE}, prints help and exits}

\item{verbosity}{Character; one of \verb{"NONE","ERROR","WARNING","INFO","DEBUG"}}

\item{trial}{Logical or integer; if \code{TRUE} or >0, quits after initialization (default: \code{FALSE})}

\item{ip}{Character; IP address to bind (default: \code{"0.0.0.0"})}

\item{port}{Integer; TCP port to listen on (default: \code{5001})}

\item{threads}{Integer; number of worker threads (default: \code{8})}

\item{shared_memory}{Logical; load graph from shared memory (default: \code{FALSE})}

\item{memory_file}{Character or NULL; DEPRECATED (behaves like \code{mmap})}

\item{mmap}{Logical; memory-map data files (default: \code{FALSE})}

\item{dataset_name}{Character or NULL; name of shared memory dataset}

\item{algorithm}{Character or NULL; one of \verb{"CH","CoreCH","MLD"}. If \code{NULL} (default), auto-selected based on file extension}

\item{max_viaroute_size}{Integer (default: \code{500})}

\item{max_trip_size}{Integer (default: \code{100})}

\item{max_table_size}{Integer (default: \code{100})}

\item{max_matching_size}{Integer (default: \code{100})}

\item{max_nearest_size}{Integer (default: \code{100})}

\item{max_alternatives}{Integer (default: \code{3})}

\item{max_matching_radius}{Integer; use \code{-1} for unlimited (default: \code{-1})}

\item{quiet}{Logical; when \code{TRUE}, suppresses package messages.}

\item{verbose}{Logical; reserved for controlling future server verbosity, included
for interface consistency with \code{\link[=osrm_start]{osrm_start()}}. Defaults to \code{FALSE}.}

\item{echo_cmd}{Logical; echo command line to console before launch (default: \code{FALSE})}
}
\value{
A \code{processx::process} object for the running server (also registered internally).
}
\description{
Launches an \code{osrm-routed} process pointing at a localized OSRM graph (either
\code{.osrm.mldgr} for MLD or \code{.osrm.hsgr} for CH/CoreCH).
}
\details{
The server's standard output and error streams can be controlled via R options
for non-interactive use or persistent logging. By default, they are captured
as pipes, which allows for reading output directly within the R session
(e.g., via \code{osrm_server$read_output_lines()}).

To redirect the server's output to one or more files, you can set the
\code{osrm.server.log_file} R option before calling this function:
\itemize{
\item \strong{Combined Log:} To send both \code{stdout} and \code{stderr} to a single file,
provide a file path:
\code{options(osrm.server.log_file = "path/to/osrm.log")}

\item \strong{Separate Logs:} To send \code{stdout} and \code{stderr} to separate files,
provide a named list:
\code{options(osrm.server.log_file = list(stdout = "out.log", stderr = "err.log"))}

\item \strong{Default Behavior:} To restore the default behavior of using pipes,
set the option to \code{NULL}:
\code{options(osrm.server.log_file = NULL)}
}

You can override the \code{osrm-routed} executable via
\code{options(osrm.routed.exec = "/full/path/to/osrm-routed")}.
}
\examples{
\donttest{
if (identical(Sys.getenv("OSRM_EXAMPLES"), "true")) {
  install_dir <- osrm_install(
    version = "latest",
    path_action = "session",
    quiet = TRUE
  )

  # Build a graph then launch an OSRM server on a custom port
  pbf_path <- system.file("extdata/cur.osm.pbf", package = "osrm.backend")
  osrm_dir <- file.path(tempdir(), paste0("osrm-", Sys.getpid()))
  dir.create(osrm_dir, recursive = TRUE)
  tmp_pbf <- file.path(osrm_dir, "cur.osm.pbf")
  file.copy(from = pbf_path, to = tmp_pbf, overwrite = TRUE)

  graph <- osrm_prepare_graph(
    input_osm = tmp_pbf,
    overwrite = TRUE,
    threads = 1L,
    algorithm = "mld"
  )

  server <- osrm_start_server(
    osrm_path = graph$osrm_job_artifact,
    port = 6000,
    threads = 1L
  )

  # Later, stop the server again
  osrm_stop(server)

  osrm_uninstall(
    dest_dir = install_dir,
    clear_path = TRUE,
    force = TRUE,
    quiet = TRUE
  )
  unlink(osrm_dir, recursive = TRUE)
}
}
}
