% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/centrality.R
\name{closeness}
\alias{closeness}
\alias{closeness.estimate}
\title{Closeness centrality of vertices}
\usage{
closeness(
  graph,
  vids = V(graph),
  mode = c("out", "in", "all", "total"),
  weights = NULL,
  normalized = FALSE,
  cutoff = -1
)
}
\arguments{
\item{graph}{The graph to analyze.}

\item{vids}{The vertices for which closeness will be calculated.}

\item{mode}{Character string, defined the types of the paths used for
measuring the distance in directed graphs. \dQuote{in} measures the paths
\emph{to} a vertex, \dQuote{out} measures paths \emph{from} a vertex,
\emph{all} uses undirected paths. This argument is ignored for undirected
graphs.}

\item{weights}{Optional positive weight vector for calculating weighted
closeness. If the graph has a \code{weight} edge attribute, then this is
used by default. Weights are used for calculating weighted shortest
paths, so they are interpreted as distances.}

\item{normalized}{Logical scalar, whether to calculate the normalized
closeness, i.e. the inverse average distance to all reachable vertices.
The non-normalized closeness is the inverse of the sum of distances to
all reachable vertices.}

\item{cutoff}{The maximum path length to consider when calculating the
closeness. If zero or negative then there is no such limit.}
}
\value{
Numeric vector with the closeness values of all the vertices in
\code{v}.
}
\description{
Closeness centrality measures how many steps are required to access every other
vertex from a given vertex.
}
\details{
The closeness centrality of a vertex is defined as the inverse of the
sum of distances to all the other vertices in the graph:

\deqn{\frac{1}{\sum_{i\ne v} d_{vi}}}{1/sum( d(v,i), i != v)}

If there is no (directed) path between vertex \code{v} and \code{i}, then
\code{i} is omitted from the calculation. If no other vertices are reachable
from \code{v}, then its closeness is returned as NaN.

\code{cutoff} or smaller. This can be run for larger graphs, as the running
time is not quadratic (if \code{cutoff} is small). If \code{cutoff} is
negative (which is the default), then the function calculates the exact
closeness scores. Since igraph 1.6.0, a \code{cutoff} value of zero is treated
literally, i.e. path with a length greater than zero are ignored.

Closeness centrality is meaningful only for connected graphs. In disconnected
graphs, consider using the harmonic centrality with
\code{\link[=harmonic_centrality]{harmonic_centrality()}}
}
\examples{

g <- make_ring(10)
g2 <- make_star(10)
closeness(g)
closeness(g2, mode = "in")
closeness(g2, mode = "out")
closeness(g2, mode = "all")

}
\references{
Freeman, L.C. (1979). Centrality in Social Networks I:
Conceptual Clarification. \emph{Social Networks}, 1, 215-239.
}
\seealso{
Centrality measures
\code{\link{alpha_centrality}()},
\code{\link{authority_score}()},
\code{\link{betweenness}()},
\code{\link{diversity}()},
\code{\link{eigen_centrality}()},
\code{\link{harmonic_centrality}()},
\code{\link{hits_scores}()},
\code{\link{page_rank}()},
\code{\link{power_centrality}()},
\code{\link{spectrum}()},
\code{\link{strength}()},
\code{\link{subgraph_centrality}()}
}
\author{
Gabor Csardi \email{csardi.gabor@gmail.com}
}
\concept{centrality}
\keyword{graphs}
