% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mu_from_ES.R
\name{mu_from_ES}
\alias{mu_from_ES}
\title{Convenience function to calculate the means for between designs with one factor (One-Way ANOVA). Can be used to determine the means that should yield a specified effect sizes (expressed in Cohen's f).}
\usage{
mu_from_ES(K, ES)
}
\arguments{
\item{K}{Number of groups (2, 3, or 4)}

\item{ES}{Effect size (eta-squared)}
}
\value{
Returns vector of means
}
\description{
Convenience function to calculate the means for between designs with one factor (One-Way ANOVA). Can be used to determine the means that should yield a specified effect sizes (expressed in Cohen's f).
}
\section{References}{

Albers, C., & Lakens, D. (2018). When power analyses based on pilot data are biased: Inaccurate effect size estimators and follow-up bias. Journal of Experimental Social Psychology, 74, 187–195. https://doi.org/10.1016/j.jesp.2017.09.004
}

\examples{
## Medium effect size (eta-squared), 2 groups
ES <- 0.0588
K <- 2
mu_from_ES(K = K, ES = ES)
}
