% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{sm_plot_topic_frequency}
\alias{sm_plot_topic_frequency}
\title{Plot Topic Frequency Distribution}
\usage{
sm_plot_topic_frequency(model, dtm, threshold = 0.3)
}
\arguments{
\item{model}{A fitted topic model (LDA, STM, or CTM).}

\item{dtm}{The document-term matrix used to train the model.}

\item{threshold}{Minimum gamma probability for topic assignment.
Default is 0.3.}
}
\value{
A ggplot object.
}
\description{
Creates a bar chart showing how many documents are assigned to each topic.
}
\examples{
\dontrun{
# Requires trained model from sm_train_lda()
lda_model <- sm_train_lda(dtm, k = 10)
sm_plot_topic_frequency(lda_model, dtm)
}
}
