% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobol4r_design.R
\name{sobol_design}
\alias{sobol_design}
\title{Create Sobol Sampling Designs}
\usage{
sobol_design(
  n,
  d,
  lower = rep(0, d),
  upper = rep(1, d),
  quasi = FALSE,
  seed = NULL
)
}
\arguments{
\item{n}{Integer, number of rows per design matrix.}

\item{d}{Integer, number of model parameters.}

\item{lower}{Numeric vector of length d containing lower bounds.}

\item{upper}{Numeric vector of length d containing upper bounds.}

\item{quasi}{Logical, when \code{TRUE} a Halton sequence is used.}

\item{seed}{Optional integer used to initialise the RNG state.}
}
\value{
A list with matrices \code{A} and \code{B} plus the column names.
}
\description{
Generate the two-sample matrices (A and B) that are required to apply
Monte Carlo Sobol estimators. The helper can rely on pseudo random numbers
or on a light-weight Halton low-discrepancy sequence to increase coverage.
}
\examples{
design <- sobol_design(n = 64, d = 3, quasi = TRUE)
str(design)
}
