% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.simple_eiv.R
\name{joint_test}
\alias{joint_test}
\alias{joint_test.simple_eiv}
\title{Joint Confidence Region Test for Method Agreement}
\usage{
joint_test(object, ...)

\method{joint_test}{simple_eiv}(
  object,
  ideal_intercept = 0,
  ideal_slope = 1,
  conf.level = 0.95,
  ...
)
}
\arguments{
\item{object}{A \code{simple_eiv} object from \code{dem_reg()} or \code{pb_reg()}.}

\item{...}{Additional arguments (currently unused).}

\item{ideal_intercept}{The hypothesized intercept value (default: 0).}

\item{ideal_slope}{The hypothesized slope value (default: 1).}

\item{conf.level}{Confidence level for the test (default: 0.95).}
}
\value{
An object of class \code{htest} containing:
\describe{
\item{statistic}{The Mahalanobis distance (chi-squared distributed with df=2).}
\item{parameter}{Degrees of freedom (always 2).}
\item{p.value}{The p-value for the test.}
\item{conf.int}{The confidence level used.}
\item{estimate}{Named vector of estimated intercept and slope.}
\item{null.value}{Named vector of hypothesized intercept and slope.}
\item{alternative}{Description of the alternative hypothesis.}
\item{method}{Description of the test.}
\item{data.name}{Name of the input object.}
}
}
\description{
Tests whether the estimated intercept and slope jointly fall within a
confidence region around specified ideal values (typically intercept=0
and slope=1 for method comparison studies).
}
\details{
The test computes the Mahalanobis distance between the estimated coefficients
and the hypothesized values using the variance-covariance matrix of the
estimates. Under the null hypothesis, this distance follows a chi-squared
distribution with 2 degrees of freedom.

For Deming regression, the variance-covariance matrix is computed via
jackknife. For Passing-Bablok regression, bootstrap resampling must have
been performed (i.e., \code{boot_ci = TRUE} in the original call).
}
