% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abc.R
\name{continue_abc}
\alias{continue_abc}
\alias{continue_abc,SimInf_abc-method}
\title{Run more generations of ABC SMC}
\usage{
continue_abc(
  object,
  tolerance = NULL,
  data = NULL,
  verbose = getOption("verbose", FALSE),
  post_gen = NULL
)

\S4method{continue_abc}{SimInf_abc}(
  object,
  tolerance = NULL,
  data = NULL,
  verbose = getOption("verbose", FALSE),
  post_gen = NULL
)
}
\arguments{
\item{object}{The \code{SimInf_abc} object to continue from.}

\item{tolerance}{A numeric matrix (number of summary statistics
\eqn{\times} number of generations) where each column contains
the tolerances for a generation and each row contains a
sequence of gradually decreasing tolerances. Can also be a
numeric vector if there is only one summary statistic. The
tolerance determines the number of generations of ABC-SMC to
run.}

\item{data}{Optional data to be passed to the
\code{SimInf_abc@fn} function. Default is \code{NULL}.}

\item{verbose}{prints diagnostic messages when \code{TRUE}. The
default is to retrieve the global option \code{verbose} and
use \code{FALSE} if it is not set.}

\item{post_gen}{An optional function that, if non-NULL, is applied
after each completed generation. The function must accept one
argument of type \code{SimInf_abc} with the current state of
the fitting process. This function can be useful to, for
example, save and inspect intermediate results.}
}
\value{
A \code{SimInf_abc} object.
}
\description{
Run more generations of ABC SMC
}
