% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SelectBoost.beta-package.R
\docType{package}
\name{SelectBoost.beta-package}
\alias{SelectBoost.beta-package}
\alias{SelectBoost.beta}
\title{SelectBoost.beta: Stability-Selection via Correlated Resampling for Beta-Regression Models}
\description{
Adds variable-selection functions for Beta regression models (both mean and phi submodels) so they can be used within the 'SelectBoost' algorithm. Includes stepwise AIC, BIC, and corrected AIC on betareg() fits, 'gamlss'-based LASSO/Elastic-Net, a pure 'glmnet' iterative re-weighted least squares-based selector with an optional standardization speedup, and 'C++' helpers for iterative re-weighted least squares working steps and precision updates. Also provides a fastboost_interval() variant for interval responses, comparison helpers, and a flexible simulator simulation_DATA.beta() for interval-valued data. For more details see Bertrand and Maumy (2023) \doi{10.7490/f1000research.1119552.1}.
}
\examples{

set.seed(1)
n <- 150; p <- 6
X <- matrix(rnorm(n*p), n, p); colnames(X) <- paste0("x",1:p)
eta <- 0.4 + X[,1] - 0.7*X[,3]
mu  <- plogis(eta)
Y   <- rbeta(n, mu*25, (1-mu)*25)

betareg_step_aic(X, Y)    # should return (Intercept) + x1,x3 nonzero often
betareg_step_bic(X, Y)
betareg_step_aicc(X, Y)

}
\references{
Bertrand, F. and Maumy, M. (2023). Improving variable selection in Beta
regression models using correlated resampling. Presented at Joint
Statistical Meetings 2023, Toronto, Canada.

Bertrand, F. and Maumy, M. (2023). SelectBoost4Beta: Improving variable
selection in Beta regression models. Presented at BioC2023, Boston, USA.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://fbertran.github.io/SelectBoost.beta/}
  \item \url{https://github.com/fbertran/SelectBoost.beta/}
  \item Report bugs at \url{https://github.com/fbertran/SelectBoost.beta/issues/}
}

}
\author{
This package was written by Frédéric Bertrand.
Maintainer: Frédéric Bertrand \href{mailto:frederic.bertrand@lecnam.net}{frederic.bertrand@lecnam.net}
}
\keyword{internal}
