% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.x.R
\encoding{UTF-8}
\name{matrix.x}
\alias{matrix.x}
\title{Matrix X}
\usage{
matrix.x(
  comm,
  traits,
  scale = TRUE,
  ranks = TRUE,
  transformation = "standardized",
  spp.weights = NULL,
  notification = TRUE,
  ...
)
}
\arguments{
\item{comm}{Community data, with species as columns and sampling units as
rows. This matrix can contain either presence/absence or abundance data.}

\item{traits}{Matrix or data frame of species described by traits, with traits as
columns and species as rows.}

\item{scale}{Logical argument (TRUE or FALSE) to specify if the traits are
measured on different scales (Default scale = TRUE). When scale = TRUE traits
are measured on different scales the matrix of traits is subjected to
standardization within each trait, and Gower Index is used to calculate the
degree of belonging to the species. When scale = FALSE traits are measured on
the same scale the matrix of traits is not subjected to standardization,
and Euclidean distance is calculated to determine the degree of belonging to
the species.}

\item{ranks}{Logical argument (TRUE or FALSE) to specify if ordinal variables are
convert to ranks (Default ranks = TRUE).}

\item{transformation}{Method to community data transformation, "none", "standardized"
or "weights" (Default transformation = "standardized").}

\item{spp.weights}{Vector with 0 or 1 to specify individual species weights (Default
spp.weights = NULL).}

\item{notification}{Logical argument (TRUE or FALSE) to specify if
notifications of missing observations are shown (Default notification =
TRUE).}

\item{...}{Parameters for \code{\link[FD]{gowdis}} function.}
}
\value{
\item{matriz.w}{Standardized community matrix, where rows are
communities and columns species. If default transformation, row totals (communities) = 1.}
\item{matriz.u}{Standardized matrix containing the degree of belonging of
each species in relation to each other species. Row totals (species) = 1.}
\item{matriz.X}{Trait-weighted species composition matrix. If default transformation,
row totals (communities) = 1.}
}
\description{
Function to obtain a matrix containing trait-weighted species composition.
For more details, see \code{\link{syncsa}}.
}
\note{
\strong{IMPORTANT}: The sequence species show up in community data
matrix MUST be the same as they show up in traits matrix or in the spp.weights vector. See
\code{\link{organize.syncsa}}.
}
\examples{
data(ADRS)
matrix.x(ADRS$community, ADRS$traits)
}
\references{
Pillar, V.D.; Duarte, L.d.S. (2010). A framework for
metacommunity analysis of phylogenetic structure. Ecology Letters, 13,
587-596.

Pillar, V.D., Duarte, L.d.S., Sosinski, E.E. & Joner, F. (2009).
Discriminating trait-convergence and trait-divergence assembly patterns in
ecological community gradients. Journal of Vegetation Science, 20, 334:348.
}
\seealso{
\code{\link{syncsa}}, \code{\link{organize.syncsa}}, \code{\link{belonging}},
\code{\link{matrix.t}}, \code{\link{matrix.p}}, \code{\link[FD]{gowdis}}
}
\author{
Vanderlei Julio Debastiani <vanderleidebastiani@yahoo.com.br>
}
\keyword{SYNCSA}
