% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datquality.R
\name{datquality}
\alias{datquality}
\title{Diversity Metrics of Simulated and Original Data}
\usage{
datquality(data, dat.sim, Par, transformation, method)
}
\arguments{
\item{data}{Data frame with species as columns and samples as rows. The first column should indicate the site to which the sample belongs, regardless of whether a single site was sampled.}

\item{dat.sim}{List of simulated data sets generated by \code{\link{simdata}}.}

\item{Par}{List of parameters generated by \code{\link{assempar}}.}

\item{transformation}{Mathematical transformation to reduce the weight of dominant species: one of "square root", "fourth root", "Log (X+1)", "P/A", or "none".}

\item{method}{Dissimilarity metric used for multivariate dispersion, passed to \code{\link[vegan]{vegdist}}.}
}
\value{
A data frame containing the mean and standard deviation of richness and diversity per sampling unit,
and the MVD for original data, as well as the 0.95 quantile of MVD from the simulated data.
}
\description{
Estimates the average number of species and the Simpson diversity index per sampling unit,
as well as the total multivariate dispersion of both the original (pilot) and simulated datasets.
}
\details{
The quality of the simulated data sets is evaluated by statistical similarity to the pilot data.
This includes: (i) the average number of species per sampling unit, (ii) the average Simpson diversity index,
and (iii) the multivariate dispersion (MVD), defined as the average dissimilarity of each sampling unit to the
group centroid in the dissimilarity space (Anderson 2006). For simulated datasets, mean and standard deviation
are reported for (i) and (ii), and the 0.95 quantile of the MVD distribution is used to describe its variability.
}
\note{
It is desirable that simulated data resemble observed data in species richness and diversity per sampling unit.
}
\examples{
## Single site: micromollusk from Cayo Nuevo (Yucatan, Mexico)
data(micromollusk)
par.mic <- assempar(data = micromollusk, type = "P/A", Sest.method = "average")
sim.mic <- simdata(par.mic, cases = 2, N = 10, sites = 1)
qua.mic <- datquality(data = micromollusk, dat.sim = sim.mic, Par = par.mic,
                      transformation = "none", method = "jaccard")
qua.mic

## See the full multi-site workflow in the vignette

}
\references{
Anderson, M. J. (2006). Distance-based tests for homogeneity of multivariate dispersions. Biometrics, 62, 245–253.

Guerra-Castro, E.J., Cajas, J.C., Simões, N., Cruz-Motta, J.J., & Mascaró, M. (2021). SSP: an R package to estimate sampling effort in studies of ecological communities. Ecography 44(4), 561-573. doi: \doi{10.1111/ecog.05284}
}
\seealso{
\code{\link[vegan]{vegdist}}, \code{\link[vegan]{diversity}}
}
