% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Jellyfish.R
\docType{data}
\name{Jellyfish}
\alias{Jellyfish}
\title{Length and width of jellyfish}
\format{
A data frame with 46 rows (one per jellyfish) and 3 columns:
\describe{
  \item{Location}{the location of the jellyfish; one of \code{Dangar} (Dangar Island) or \code{Salamander} (Salamander Bay)}
  \item{Width}{the width (breadth) of the jellyfish, in mm}
  \item{Length}{the length of the jellyfish, in mm}
}
}
\source{
D. J. Hand, F. Daly, A. D. Lunn, K. J. McConway, and E. Ostrowski (1994) 
A Handbook of Small Data Sets, London: Chapman and Hall. Dataset 72.
}
\usage{
data(Jellyfish)
}
\description{
Width and length of jellyfish at two locations.
}
\examples{
boxplot(Width ~ Location, data = Jellyfish, ylab = "Breadth (mm)")

}
\references{
Lunn, A. D. and McNeil, D. R. (1991).
\emph{Computer-Interactive Data Analysis}, Chichester: John Wiley and Sons.
}
\keyword{datasets}
