% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAKTI.R
\name{Thermo_parameters}
\alias{Thermo_parameters}
\title{Estimation of Thermodynamic Parameters}
\usage{
Thermo_parameters(lnKd, Temp, Slope, Intercept)
}
\arguments{
\item{lnKd}{Natural logarithm of distribution coefficient corresponding to each initial graded concentrations}

\item{Temp}{Temperature in Kelvin}

\item{Slope}{Estimated slope of the fitted line}

\item{Intercept}{Estimated intercept of the fitted line}
}
\value{
\itemize{
  \item Delta_H: Change in the standard enthalpy
  \item Delta_S: Change in the standard entropy
  \item Delta_G: Change in the standard Gibbs free energy
  \item Descriptive: Mean and standard error of the thermodynamic parameters
}
}
\description{
Calculates delta H, delta S, and delta G across temperature and non-temperature treatments using regression-derived slope and intercept values, integrating van’t Hoff and Gibbs-based relationships. This function assesses spontaneity, energetic favourability, and system randomness, providing a comprehensive thermodynamic profile for interpreting adsorption energetics.
}
\examples{
lnKd <- c(7,8)
Temp <- 298
Slope <- c(-180, -200)
Intercept <- c(5, 6)
my.tp <- Thermo_parameters(lnKd, Temp, Slope, Intercept)
}
\references{
\itemize{
\item Roy, A., Manjaiah, K. M., Datta, S. P., Rakshit, D., Barman, M., Ray, P., Golui, D., Raza, M. B., Tigga, P., Mondal, S., Vishwanath, Meena, S., & Meena, P. (2025). Effect of Low-Molecular-Weight Organic Acids and Silicon on Arsenic Adsorption and Desorption in a Paddy Soil of Bengal Delta Plain: Insights from Thermodynamics and Equilibrium Modeling. Water, Air, & Soil Pollution, 236(6), 344. https://doi.org/10.1007/s11270-025-07963-7
\item Yi, Z., Yao, J., Zhu, M., Chen, H., Wang, F., & Liu, X. (2016). Kinetics, equilibrium, and thermodynamics investigation on the adsorption of lead (II) by coal-based activated carbon. SpringerPlus, 5(1), 1160. https://doi.org/10.1186/s40064-016-2839-4
}
}
