% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/semUtils.R
\name{graph2dag}
\alias{graph2dag}
\title{Convert directed graphs to directed acyclic graphs (DAGs)}
\usage{
graph2dag(graph, data, bap = FALSE, time.limit = Inf, ...)
}
\arguments{
\item{graph}{A directed graph as an igraph object.}

\item{data}{A data matrix with subjects as rows and variables as
columns.}

\item{bap}{If TRUE, a bow-free acyclic path (BAP) is returned
(default = FALSE).}

\item{time.limit}{CPU time for the computation, in seconds
(default = Inf).}

\item{...}{Currently ignored.}
}
\value{
A DAG as an igraph object.
}
\description{
Remove cycles and bidirected edges from a directed graph.
}
\details{
The conversion is performed firstly by removing bidirected
edges and then the data matrix is used to compute edge P-values, through
marginal correlation testing (see \code{\link[SEMgraph]{weightGraph}},
r-to-z method). When a cycle is detected, the edge with highest
P-value is removed, breaking the cycle. If the bap argument is TRUE,
a BAP is generated merging the output DAG and the bidirected edges
from the input graph.
}
\examples{

dag <- graph2dag(graph = sachs$graph, data = log(sachs$pkc))
old.par <- par(no.readonly = TRUE)
par(mfrow=c(1,2), mar=rep(1, 4))
gplot(sachs$graph, main = "Input graph")
gplot(dag, main = "Output DAG")
par(old.par)

}
\author{
Mario Grassi \email{mario.grassi@unipv.it}
}
