% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_open_wbo.R
\name{run_open_wbo}
\alias{run_open_wbo}
\title{Run open-wbo_static}
\usage{
run_open_wbo(args = character())
}
\arguments{
\item{args}{Character vector of arguments passed to `open-wbo_static`.}
}
\value{
Character string containing the output from `open-wbo_static`.
}
\description{
Run the bundled `open-wbo_static` binary with user-supplied parameters.
}
\details{
`args` is passed directly to the `open-wbo_static` command-line tool, so supply
the path to a WCNF file along with any solver flags you want to enable. To see
the full list of supported options for your bundled binary, run
`run_open_wbo("--help")`. The help text is emitted on stderr, so it appears in
your console but is not returned by `run_open_wbo()`.

Common solver options include toggles such as `-forceunsat`/`-no-forceunsat`,
`-adapt`/`-no-adapt`, `-print-model`/`-no-print-model`, and parameter settings
like `-algorithm <int>`, `-cpu-lim <int>`, `-mem-lim <int>`, and
`-verbosity <int>`.
}
\examples{
\donttest{
wcnf_file <- tempfile(fileext = ".wcnf")
writeLines(c(
  "p wcnf 1 2 2",
  "2 1 0",
  "1 -1 0"
), wcnf_file)
run_open_wbo(args = wcnf_file)
}
}
