% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.RprobitB_fit.R
\name{predict.RprobitB_fit}
\alias{predict.RprobitB_fit}
\title{Predict choices}
\usage{
\method{predict}{RprobitB_fit}(object, data = NULL, overview = TRUE, digits = 2, ...)
}
\arguments{
\item{object}{An object of class \code{RprobitB_fit}.}

\item{data}{Either
\itemize{
\item \code{NULL}, using the data in \code{object},
\item an object of class \code{RprobitB_data}, for example the test part
generated by \code{\link{train_test}},
\item or a data frame of custom choice characteristics. It must have the
same structure as \code{choice_data} used in \code{\link{prepare_data}}.
Missing columns or \code{NA} values are set to 0.
}}

\item{overview}{[\code{logical(1)}]\cr
Summarize the prediction in a confusion matrix?}

\item{digits}{[\code{integer(1)}]\cr
The number of digits of the returned choice probabilities.}

\item{...}{Currently not used.}
}
\value{
Either a table if \code{overview = TRUE} or a data frame otherwise.
}
\description{
This function predicts the discrete choice behaviour.
}
\details{
Predictions are made based on the maximum predicted probability for each
choice alternative.

See \href{https://loelschlaeger.de/RprobitB/articles/v05_choice_prediction.html}{the vignette on choice prediction}
for a demonstration on how to visualize the model's sensitivity and
specificity by means of a receiver operating characteristic (ROC) curve.
}
\examples{
set.seed(1)
data <- simulate_choices(form = choice ~ cov, N = 10, T = 10, J = 2)
data <- train_test(data, test_proportion = 0.5)
model <- fit_model(data$train)

predict(model)
predict(model, overview = FALSE)
predict(model, data = data$test)
predict(
  model,
  data = data.frame("cov_A" = c(1, 1, NA, NA), "cov_B" = c(1, NA, 1, NA)),
  overview = FALSE
)

}
