% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zcurve.R
\name{hist.zcurve_RoBMA}
\alias{hist.zcurve_RoBMA}
\title{Create Histogram of Z-Statistics}
\usage{
\method{hist}{zcurve_RoBMA}(
  x,
  plot_type = "base",
  from = -6,
  to = 6,
  by = 0.5,
  length.out = NULL,
  add = FALSE,
  plot_thresholds = TRUE,
  dots_thresholds = NULL,
  ...
)
}
\arguments{
\item{x}{A \code{zcurve_RoBMA} object containing the fitted model.}

\item{plot_type}{whether to use a base plot \code{"base"}
or ggplot2 \code{"ggplot"} for plotting. Defaults to
\code{"base"}.}

\item{from}{Lower bound of the z-value range for plotting. Defaults to -6.}

\item{to}{Upper bound of the z-value range for plotting. Defaults to 6.}

\item{by}{Numeric value specifying the bin width for the histogram. Defaults to 0.5.}

\item{length.out}{Optional integer specifying the number of bins. If NULL, determined by \code{by}. Defaults to NULL.}

\item{add}{Logical; if TRUE, adds histogram bars to an existing plot without creating a new canvas. Only applies to base R graphics. Defaults to FALSE.}

\item{plot_thresholds}{Logical; should significance thresholds be displayed on the plot? Defaults to TRUE.}

\item{dots_thresholds}{List of additional graphical parameters for the threshold lines.
For base R: \code{col}, \code{lty}, \code{lwd}.
For ggplot2: \code{color}, \code{linetype}, \code{linewidth}.}

\item{...}{Additional graphical parameters for the histogram and basic plotting arguments.
For base R histogram: \code{border}, \code{col}, \code{density}, \code{angle}.
For ggplot2 histogram: \code{color}, \code{fill}, \code{alpha}.
Basic plotting arguments (both base R and ggplot2): \code{xlab} (x-axis label, default: "Z-Statistic"),
\code{ylab} (y-axis label, default: "Density"), \code{main} (plot title, default: ""),
\code{ylim} (y-axis limits). For base R only: \code{xaxt} (x-axis type, default: "s"),
\code{yaxt} (y-axis type, default: "s").}
}
\value{
Returns \code{NULL} if \code{plot_type = "base"}, or a \code{ggplot2} object if \code{plot_type = "ggplot2"}.
}
\description{
Plots a histogram of observed z-values for a fitted \code{zcurve_RoBMA} object, with options to customize the plotting range, bin width, and display of significance thresholds.
}
\seealso{
\code{\link[=as_zcurve]{as_zcurve()}}, \code{\link[=plot.zcurve_RoBMA]{plot.zcurve_RoBMA()}}, \code{\link[=hist.zcurve_RoBMA]{hist.zcurve_RoBMA()}}
}
