% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Analyses_functions_2.R
\name{cross_mean}
\alias{cross_mean}
\title{Mean time between crossings}
\usage{
cross_mean(X, A, subI = NULL, plot = FALSE)
}
\arguments{
\item{X}{Data frame where the first column is a numeric time sequence \eqn{t}
and the second one is the values of the time series \eqn{X(t)}.}

\item{A}{Constant level as a numeric value.}

\item{subI}{Time sub-interval is a vector, where the lower bound is
the first element and the upper bound is the second. Optional: If provided mean crossing
times for the sub-interval is returned, otherwise the whole time interval is considered.}

\item{plot}{Logical: If \code{TRUE}, the time series, the constant level and crossing
points are plotted in interactive sessions.}
}
\value{
The estimated mean time between crossings.
}
\description{
Computes the mean duration between crossings of a time series
at a specified constant level for the provided time interval or its sub-interval.
}
\examples{
t <- seq(0, 1, length = 100)
TS <- data.frame("t" = t, "X(t)" = rnorm(100))
cross_mean(TS, 0.1, subI = c(0.2, 0.8), plot = TRUE)
}
\seealso{
\code{\link{cross_T}}, \code{\link{cross_rate}}
}
