% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.abund.r
\name{print.abund}
\alias{print.abund}
\title{Print abundance estimates}
\usage{
\method{print}{abund}(x, ...)
}
\arguments{
\item{x}{An object output by \code{abundEstim}.  This is a distance 
function object augmented with abundance estimates, and has 
class \code{c("abund", "dfunc")}.}

\item{\dots}{Included for compatibility to other print methods.
Ignored here.}
}
\value{
0 is invisibly returned
}
\description{
Print an object of class \code{c("abund","dfunc")} 
produced by \code{abundEstim}.
}
\examples{
# Load example sparrow data (line transect survey type)
data(sparrowDf)

# Fit half-normal detection function
dfunc <- sparrowDf |> dfuncEstim(formula=dist~groupsize(groupsize))

# Estimate abundance given a detection function
fit <- abundEstim(object = dfunc
                , area = setUnits(4105, "km^2")
                , ci = NULL)
print(fit)
summary(fit)

\dontrun{
# Bootstrap confidence intervals (500 iterations)
# Requires ~4 min
fit <- abundEstim(object = dfunc
                , area = setUnits(4105, "km^2")
                , ci = 0.95
                , plot.bs = TRUE
                , showProgress = TRUE)
print(fit)
summary(fit)
}

}
\seealso{
\code{\link{dfuncEstim}}, \code{\link{abundEstim}}, 
\code{\link{summary.dfunc}}, \code{\link{print.dfunc}}, 
\code{\link{summary.abund}}
}
