#' @title R Commander Miscellaneous Functions
#'
#' @name RcmdrMisc-package
#'
#' @details
#' \preformatted{
#'
#' Package:   RcmdrMisc
#'
#' Type:      Package
#'
#' Version:   2.10.1
#'
#' Date:      2026-01-03
#'
#' License:   GPL (>=3)
#' }
#'
#' Various statistical, graphics, and data-management functions used by the Rcmdr package in the R Commander GUI for R.
#' 
#' @author John Fox
#'
#' Mantainer: Manuel Munoz-Marquez <manuel.munoz@uca.es>
#'
#' @seealso \url{https://www.r-project.org}, \url{https://facsocsci.mcmaster.ca/jfox/}
#' 
#' @importFrom abind abind
#' @importFrom car showLabels hccm linearHypothesis deltaMethod Tapply
#' @importFrom colorspace rainbow_hcl
#' @importFrom e1071 skewness kurtosis
#' @importFrom foreign read.spss
#' @importFrom graphics abline arrows axis barplot box hist legend lines matplot mtext par pie plot points polygon strheight text title
#' @importFrom grDevices n2mfrow palette
#' @importFrom haven read_sas read_spss
#' @importFrom Hmisc rcorr
#' @importFrom lattice xyplot strip.default
#' @importFrom MASS stepAIC
#' @importFrom nortest ad.test cvm.test lillie.test pearson.test sf.test
#' @importFrom readxl read_excel excel_sheets
#' @importFrom sandwich vcovHAC
#' @importFrom stats coef complete.cases cor dist formula kmeans model.matrix na.omit shapiro.test p.adjust pf pt qt quantile runif sd update as.formula ftable reshape

NULL
